# 论文阅读：IOTGUARD: Dynamic Enforcement of Security and Safety Policy in Commodity IoT

> 本文来自 eunomia-bpf 社区，我们正在探索 eBPF 和 WebAssembly 相互结合的工具链和运行时: <https://github.com/eunomia-bpf/eunomia-bpf> 社区关注于简化 eBPF 程序的编写、分发和动态加载流程，以及探索 eBPF 和 Wasm 相结合的工具链、运行时和运用场景等技术。

### 摘要

——广义上定义为物联网（IoT），集成物理过程和数字连接的商品设备的增长已经改变了我们的生活、娱乐和工作方式。迄今为止，保护IoT的传统方法是逐个处理设备。然而，在实践中，最近已经表明设备之间的交互常常是安全和安全违规的真正原因。在本文中，我们介绍了IOTGUARD，一种动态的、基于策略的IoT强制执行系统，通过监测IoT和触发器动作平台应用程序的行为来保护用户免受不安全和不安全的设备状态。IOTGUARD分为三个阶段：（a）实现代码工具，将额外逻辑添加到应用程序源代码中，在运行时收集应用程序信息，（b）将应用程序信息存储在动态模型中，表示应用程序的运行时执行行为，（c）识别IoT安全和安全策略，并在单个应用程序或一组交互应用程序的动态模型上执行相关策略。我们在20个有缺陷的应用程序上演示了IOTGUARD，并发现IOTGUARD正确地执行了12个12个策略违规行为。此外，我们在35个SmartThings IoT和30个IFTTT触发器动作平台市场应用程序上进行了评估，在模拟的智能家居中执行。IOTGUARD执行11个独特的策略，并在6个（17.1%）SmartThings和五个（16.6%）IFTTT应用程序中阻止16个状态。IOTGUARD仅对一个应用程序产生17.3%的运行时开销，对五个交互应用程序产生19.8%的运行时开销。通过这一努力，我们引入了一个严谨的系统，通过系统地确定的IoT策略来强制执行IoT设备的正确操作，展示了像IOTGUARD这样的工具监测IoT应用程序的有效性和价值。

### IOT守卫与传统的保护物联网设备的方法有何不同？

IO TG UARD解决了物联网设备在传感器、资源和设备之间的互动方面的多样性，这提出了独特的挑战，需要一种不同的方法来维护物联网环境的安全性和保障。与传统方法不同，IO TG UARD是一种基于策略的动态执行系统，用于保护用户免受不安全和不安全的设备状态的影响，通过监视物联网的行为和触发操作平台应用程序。它分为三个阶段：（a）实现代码注入器，向应用程序源代码添加额外的逻辑，以在运行时收集应用程序信息，（b）将应用程序信息存储在动态模型中，该模型表示应用程序的运行时执行行为，和（c）识别物联网安全和安全策略，并在单个应用程序或一组交互应用程序的动态模型上执行相关策略。这些信息可以在第1页找到。

传统的物联网安全和隐私方法旨在通过防火墙、入侵检测、访问控制策略和软件补丁来加强物联网基础设施，抵御攻击。然而，周界安全措施并不能强制执行物理过程在物联网系统中的安全行为。例如，防火墙规则很难保证用户不在家时门锁上了。此外，过去对物联网设备和环境的分析都集中在通过源代码分析保护物联网应用程序。

传感器、资源和设备之间的交互多样化，使得保护物联网环境的安全和安全性需要一种不同的方法。因此，IOTGUARD被开发成为一种动态系统，用于在物联网设备上执行策略，通过监控物联网行为和触发操作平台应用程序来解决这些挑战。它在应用程序源代码中添加额外的逻辑，以在应用程序和多应用程序环境中收集其信息并执行安全和安全策略。

您可以在PDF文件的第1页上找到有关传统方法为何无效的更多信息。

在本文中，我们提出了 IOTGUARD，一个动态执行系统，用于管理物联网系统中最敏感的资源，即物理设备本身。IOTGUARD 直接阻止个别应用程序和多应用程序环境中不安全和不希望的状态。为了实现这一点，将应用程序与 IOTGUARD 的代码块断言进行了仪表化。在此，IOTGUARD 建立了应用程序的生命周期，并添加了代码以获取应用程序的事件、操作和保护每个操作的谓词。仪表化的应用程序在订阅事件发生时执行。应用程序在执行操作之前将其信息（例如事件和操作）传输到 IOTGUARD。应用程序的信息存储在一个动态模型中，该动态模型由转换和状态组成。动态模型表示单个应用程序的运行时执行行为，如果应用程序不与其他应用程序交互，则表示该应用程序的运行时执行行为，以及应用程序交互时的统一行为。从这个模型中，IOTGUARD 将一个应用程序的（统一的）动态模型与一组系统化开发的物联网策略进行评估。策略是一个系统构件，表示用户对物联网系统的安全行为规范的物理行为规范。如果一个应用程序的操作未能通过策略，IOTGUARD 通过通知应用程序拒绝消息来执行策略违规；否则是通过消息。受控安全服务的响应条件化仪表化应用程序的操作；因此，违反策略的应用程序的操作将被阻止或允许，具体取决于响应。

### 背景

物联网系统将物理过程与数字连接相结合。无论其目的和复杂性如何，物联网系统通常会从下到上构建其架构，包括设备、连接协议和物联网编程平台。这些系统经常使用中心化的中枢作为连接物理环境中设备的网关，使用云同步设备状态并提供远程控制和监视的接口。设备配备了嵌入式传感器和执行器，使其能够与物理环境进行交互。传感器收集物理状态并向其他设备、中枢或云发送事件。事件会被处理并用于激活设备。例如，存在传感器检测到存在事件并与灯光开关（执行器）通信，从而打开灯光。我们注意到，只要移动电话甚至咖啡机能够感知其环境，它们也可以是传感器。协议用于建立异构设备和网络端点之间的通信。这些协议根据环境的约束条件进行选择，例如低功率或无损连接。物联网编程平台负责通过管理设备及其互动提供特定于应用程序的服务。它们还使关键功能（如数据收集、控制和互操作性）成为可能。近年来，在各种领域出现了多个物联网编程平台：苹果的HomeKit [5]、OpenHAB [41]、三星的SmartThings [43]用于智能家居、Android Sensor API [2]、Google Fit用于可穿戴设备[20]、ThingWorx [42]用于工业应用以及FarmBeats [50]用于农业。这些平台提供基于Web的环境和工具，使开发人员可以通过各种API编写应用程序。

触发-动作平台
诸如IFTTT [26]、Zapier [53]和Apiant [4]的触发-动作平台允许用户将服务连接在一起。服务包括触发-动作平台上的一组API。用户授权服务到其触发-动作平台帐户。例如，拥有SmartThings IoT平台帐户的用户可以通过OAuth协议授权SmartThings服务与其SmartThings帐户通信。服务使用HTTP(S) [6]，[18]上的REST API相互通信。触发-动作平台允许用户通过DO和IF规则在服务上创建自定义自动化。这些规则允许用户将服务中的触发器连接到另一个服务的所需动作 - 当服务中发生事件时，平台会自动触发另一个服务的单独操作。DO规则充当虚拟按钮触发器以执行一组操作；例如，DO规则可以在用户点击按钮时打开智能开关。IF规则使用触发器和动作将两个服务组合在一起；例如，IF规则可以在智能家居服务的运动传感器在午夜后侦测到运动时拨打保安电话。用户需要安装由触发-动作平台提供的配套应用程序来触发DO规则。用户通过触发-动作平台Web API配置IF规则后，这些规则将自动运行。截至2018年5月，IFTTT在触发-动作平台中拥有最大的市场份额[52]；它为用户提供500个服务，其中158个是物联网服务。IFTTT物联网服务分为不同的类别，例如可穿戴设备、健身和健康设备、家庭设备和监控系统。

C. 定义
我们采用一般性术语来描述物联网应用程序和触发-动作规则中的动作、事件、服务和状态。设备具有一组属性，这些属性是设备的状态。设备的动作可以改变属性。例如，门可能具有打开、打开、关闭和关闭属性，只有打开和关闭动作。当设备状态发生变化时，事件会被触发。应用程序订阅某些事件，并在该事件发生时执行操作。例如，一个应用程序订阅运动检测器的布尔属性“motion-active”事件，并将开关状态更改为“switch-on”。触发-动作平台连接不同在线服务的事件和动作。在触发-动作平台中，事件是服务中的状态更改，而操作是作为事件结果启动的函数。例如，当物联网平台中触发了“咖啡机启动”事件时，触发-动作规则可能会调用Twitter的“发布一条推文”操作。

### MOTIVATION AND ASSUMPTIONS

这篇论文解决的问题是物联网设备相互交互导致不安全和不安全状态日益增加的问题。本文的动机是解决物联网设备中传感器、资源和设备之间的交互的多样性所带来的挑战，需要采用不同的方法来保护物联网环境的安全性和安全性。

为了说明这个问题，文章提出了一个场景，其中有三个物联网应用程序和两个触发-动作规则在共享环境中。欢迎回家的应用程序在客厅的灯亮时将模式设置为家庭模式。家居模式自动化应用程序在激活家居模式时打开加热器和炊具，并解锁庭院门。好夜晚应用程序在灯关闭时根据用户定义的时间设置闹钟并冲咖啡。这些应用程序之间的交互可能会导致不安全或不安全的设备状态。

因此，IOTG UARD被开发为物联网设备上的策略执行动态系统，通过监视物联网和触发器动作平台应用程序的行为来解决这些挑战。它在应用程序的源代码中添加额外的逻辑来收集其信息，并在应用程序和多应用程序环境中执行安全和安全策略。

您可以在PDF文件的第3页找到更多信息。

### 四种类型的信息

代码仪器向应用程序的源代码添加额外的逻辑，以在运行时收集其四种类型的信息：（1）设备和事件，（2）事件处理程序中每个事件调用的操作，（3）守卫设备操作的谓词（IoT应用程序可以有条件地更改设备状态，例如，当能源消耗超过某个阈值时，应用程序可能关闭开关，并在能源消耗低于另一个阈值时打开开关。因此，这些设备更改仅发生在有条件分支中的谓词成立时），以及（4）设备操作的数值属性（某些设备需要数值值来调用操作，例如，恒温器需要一个离散的数值属性来设置温度加热点）。被仪器化的应用程序在接收事件并在执行操作之前将信息传输到IOTGUARD的数据收集器。此外，仪器化器在每个设备操作之前插入一个保护程序，该保护程序根据安全服务的响应允许或阻止操作。

收集运行时信息。代码仪表盘模拟了应用程序的生命周期，包括其入口点、事件处理程序方法和调用图。然后，它插入必要的插装代码，以收集应用程序的运行时信息，以进行策略执行。从应用程序的跨过程控制流图（ICFG）中，仪表盘分为三个步骤：（1）首先识别应用程序的操作，（2）对于每个操作，然后执行基于路径的静态分析，以收集触发操作的事件，操作的路径条件以及操作调用中的数字值属性，（3）在操作之前插入插装代码，以将操作的信息传输给数据收集器。如果多个操作具有相同的信息（事件、路径条件等），则它们的插装代码是共享的。此外，插装代码还发送与操作或事件相关联的设备ID到数据收集中；设备ID对于确定设备之间的因果关系非常重要。例如，用户可能有多个智能开关来控制一组设备；因此，打开事件必须与特定开关相关联。
为说明，我们使用“家庭-离家”IoT应用程序的伪代码，如图5所示。当用户到达家时，应用程序解锁前门，打开一组灯并设置恒温器温度到特定值（如果功耗小于阈值）。当她离开时，它锁定前门，关闭灯光，并将恒温器设置为另一个特定值。代码仪表器搜索应用程序的入口点，并找到两个入口点：未出现的事件处理程序，该事件处理程序关闭开关，锁定门并设置温度（行10-12），以及出现的事件处理程序，该事件处理程序打开开关，解锁门并设置温度（行13-18）。对于每个操作，代码仪器找到保护操作的谓词以及操作调用中使用的数字值属性。例如，当出现事件发生时，s.on()和d.unlock()操作都会触发。由于两个操作共享相同的信息（事件和路径条件），因此在它们之前插入单个插装代码块；特别是，在第15行之前插入代码块，以将以下信息传输到数据收集器

我们注意到IoT应用程序的代码仪器逻辑取决于IoT编程平台提供的API。例如，一些平台明确允许访问事件值（例如，存在）和设备ID，而其他平台通过事件对象（例如event.value和event.deviceID）提供此信息。我们在第VI节中介绍了IOTGUARD在我们的目标IoT平台SmartThings上的代码仪器逻辑。
保护操作。 IOTGUARD的主要功能是保护用户免受不良设备状态的影响。因此，在每个操作之前，仪器还插入一个保护程序，该保护程序基于安全服务的决策进行谓词化。这允许应用程序根据从安全服务返回的响应执行操作。如果与事件相关联的操作通过了所有策略，则安全服务将为保护操作返回true。这意味着允许应用程序执行该操作。如果应用程序违反策略，则返回false;因此，不执行设备操作以保护系统安全。例如，当用户不存在时（第11行），d.lock()操作由谓词response [“door.lock”]保护。我们将在第V-C节中更多地讨论安全服务。

### Experimental Setup.

我们模拟了如图10所示的智能家居。智能家居包括20个不同的物联网设备，总共29个设备。一些物联网设备被多次部署；例如，水泄漏探测器（11）被部署在厨房和浴室。这些设备是智能家居中最畅销的物联网消费品[1]。为了为智能家居设备建立自动化任务，我们从SmartThings GitHub仓库[40]获取了35个官方（审核过的）物联网应用程序（M.ST1-M.ST35），并从IFTTT市场[25]，[47]获取了30个官方IFTTT应用程序（M.IFTTT1-M.IFTTT30）（见表III）。IFTTT应用程序将七个物联网设备连接到十二个独特的服务，例如Google语音和电话。这些应用程序和应用程序包括各种设备、服务和功能，涵盖了不同的现实生活用例。一些应用程序需要预定义的模式输入。我们根据SmartThings文档中模式的用例，定义了四种模式，家庭、离开、睡眠和度假。我们生成应用程序的所有事件来触发其所有事件处理程序方法。如果应用程序需要输入数值型设备属性的输入，则根据应用逻辑在设备支持的范围内生成输入（类似于引导模糊测试覆盖应用程序代码的方式[48]）。例如，设置温度值的恒温器输入可以在50到95之间生成。

### 局限

IOTGUARD的局限性在于如果状态被阻止，它需要采取正确的行动。在某些情况下，仅仅阻止由用户或策略错误引起的状态可能会带来物理后果。例如，假设一扇门只有在一个基于用户指定的时间窗口的安全服务下才能解锁，而当一个阻止开门状态的策略阻止了安全服务进入房屋时，这可能是可取的，也可能不是，这取决于具体情况。为了在拒绝一个操作时保持IoT环境的稳定性，未来的工作将需要通过多个用户研究更复杂的策略，更好地处理被阻止的状态。

IOTGUARD允许用户通过IOTGUARD的GPL指定策略。这可能会带来问题，特别是当用户在高度复杂的IoT环境中创建策略时，一个不正确的策略规定可能会阻止合法的状态，无法阻止不安全和不安全状态，或与另一个策略冲突。例如，一个策略可能在特定事件发生时允许动作“a”，而另一个策略可能拒绝一组动作，其中“a”是其中的一员。为了解决这些问题，我们计划采用机器学习和其他建模技术，自动化IoT设备和领域中的属性发现过程和策略冲突解决。

IOTGUARD实现了一种算法，可以找到IFTTT触发器-动作应用程序的事件和操作。然后，我们会手动标记事件和操作的完整性和机密性标签。我们发现提取IFTTT事件和操作并标记它们并不是一个微不足道的过程，因为应用程序的事件和操作通常与IoT平台的设备功能不匹配。此外，这个过程无法扩展到大量的IFTTT应用程序。我们计划使用更具语义的自然语言处理技术，自动化和扩展应用程序处理。

我们已经证明了IOTGUARD可以表达有意义的策略，以保护系统的安全性和可靠性。我们计划进行用户研究，评估基于用户配置应用程序的IOTGUARD的可用性。我们将要求独立用户配置IoT应用程序和触发器动作应用程序，假设他们在智能家居中使用它们。然后我们将执行这些应用程序并研究IOTGUARD的有效性，重点关注策略、被阻止的状态和基于特定用户配置的用户感知风险。

最后，IOTGUARD的实现和评估仅基于SmartThings家庭自动化平台和IFTTT触发器动作平台应用程序。还有其他适合评估安全和安全性违规的IoT领域，如农业的FarmBeats[50]、医疗保健的HealthSaaS[23]、汽车工业的KaaIoT[29]、Zapier[53]和Microsoft Flow[35]的触发器动作平台。我们计划将IOTGUARD的算法扩展到这些平台，并参与对IoT市场和行业的大规模分析。

本文介绍了一种名为IOTGUARD的系统，它可以动态执行IoT设备的安全和安全策略。该系统使用代码仪器对应用程序进行分析，并在操作之前插入插装代码以收集运行时信息。IOTGUARD还包括一个安全服务，用于保护用户免受不良设备状态的影响。该系统已在SmartThings平台上进行了实验，并计划将其扩展到其他IoT平台。

> 本文来自 eunomia-bpf 社区，我们正在探索 eBPF 和 WebAssembly 相互结合的工具链和运行时: <https://github.com/eunomia-bpf/eunomia-bpf> 社区关注于简化 eBPF 程序的编写、分发和动态加载流程，以及探索 eBPF 和 Wasm 相结合的工具链、运行时和运用场景等技术。
